#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

struct Potez
{
    long long x, y;
    int indeksPomeraja;
    double ugao;
};

int main()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    int n;
    std::cin >> n;
    std::vector<Potez> potezi;
    for (int i = 0; i < n; i++)
    {
        long long x, y;
        std::cin >> x >> y;
        potezi.push_back({ x, y, i + 1, atan2((double)y, (double)x) });
    }
    sort(potezi.begin(), potezi.end(), [](const Potez& a, const Potez& b) {return a.ugao < b.ugao; });
    int m = potezi.size();
    const double PI = std::acos(-1.0);
    for (int i = 0; i < m; i++)
    {
        potezi[i].ugao += 2 * PI;
    }
    long long trX = 0;
    long long trY = 0;
    long long max = 0;
    int maxL = 0;
    int maxD = -1;
    int desni = 0;
    for (int levi = 0; levi < m; levi++)
    {
        while (desni < m && (desni == levi || potezi[desni].ugao - potezi[levi].ugao < PI))
        {
            trX += potezi[desni].x;
            trY += potezi[desni].y;
            long long d = trX * trX + trY * trY;
            if (d > max)
            {
                max = d;
                maxL = levi;
                maxD = desni;
            }
            desni++;
        }
        trX -= potezi[levi].x;
        trY -= potezi[levi].y;
        long long d = trX * trX + trY * trY;
        if (d > max)
        {
            max = d;
            maxL = levi + 1;
            maxD = desni - 1;
        }
    }
    if (maxD == -1)
    {
        std::cout << '0';
    }
    else
    {
        std::vector<int> indeksi;
        for (int i = maxL; i <= maxD; i++)
        {
            indeksi.push_back(potezi[i].indeksPomeraja);
        }
        std::cout << indeksi.size() << "\n";
        for (int i = 0; i < indeksi.size() - 1; i++)
        {
            std::cout << indeksi[i] << " ";
        }
        std::cout << indeksi[indeksi.size() - 1];
    }
    return 0;
}